/*
 * Decompiled with CFR 0.152.
 */
package dev.quantumfusion.dashloader.mixin.option.cache.font;

import com.google.common.collect.Lists;
import dev.quantumfusion.dashloader.DashDataManager;
import dev.quantumfusion.dashloader.DashLoader;
import dev.quantumfusion.dashloader.mixin.accessor.FontManagerAccessor;
import dev.quantumfusion.dashloader.mixin.accessor.FontStorageAccessor;
import dev.quantumfusion.dashloader.mixin.accessor.UnicodeTextureFontAccessor;
import dev.quantumfusion.dashloader.util.mixins.MixinThings;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.IntFunction;
import net.minecraft.class_1060;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3532;
import net.minecraft.class_3695;
import net.minecraft.class_377;
import net.minecraft.class_378;
import net.minecraft.class_379;
import net.minecraft.class_390;
import net.minecraft.class_391;
import net.minecraft.class_7191;
import org.apache.commons.lang3.tuple.Pair;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(targets={"net/minecraft/client/font/FontManager$1"})
public class FontManagerOverride {
    private Map<class_2960, Pair<Int2ObjectMap<IntList>, List<class_390>>> cache;

    @Inject(method={"method_18638", "prepare*"}, at={@At(value="HEAD")}, cancellable=true)
    private void overridePrepare(class_3300 resourceManager, class_3695 profiler, CallbackInfoReturnable<Map<class_2960, List<class_390>>> cir) {
        if (DashLoader.DL.active() && DashLoader.DL.isRead() && DashLoader.DL.getData().fonts.dataAvailable()) {
            DashDataManager.DashDataHandler<Map<class_2960, List<class_390>>> fonts = DashLoader.DL.getData().fonts;
            Map<class_2960, List<class_390>> cacheResultData = fonts.getCacheResultData();
            cacheResultData.forEach((identifier, list) -> list.forEach(font -> {
                if (font instanceof class_391) {
                    ((UnicodeTextureFontAccessor)font).setResourceManager(resourceManager);
                }
            }));
            this.prepareFonts(cacheResultData);
            cir.setReturnValue(cacheResultData);
        }
    }

    private void prepareFonts(Map<class_2960, List<class_390>> map) {
        DashLoader.LOG.info("Preparing fonts");
        Object2ObjectOpenHashMap cache = new Object2ObjectOpenHashMap();
        map.forEach((arg_0, arg_1) -> this.lambda$prepareFonts$2((Map)cache, arg_0, arg_1));
        this.cache = cache;
    }

    @Inject(method={"method_18635", "apply*"}, at={@At(value="HEAD")}, cancellable=true)
    private void overrideApply(Map<class_2960, List<class_390>> map, class_3300 resourceManager, class_3695 profiler, CallbackInfo ci) {
        if (DashLoader.DL.active() && DashLoader.DL.isRead() && DashLoader.DL.getData().fonts.dataAvailable()) {
            profiler.method_16065();
            profiler.method_15396("closing");
            FontManagerAccessor fontManagerAccessor = (FontManagerAccessor)MixinThings.FONTMANAGER;
            Map<class_2960, class_377> fontStorages = fontManagerAccessor.getFontStorages();
            fontStorages.values().forEach(class_377::close);
            fontStorages.clear();
            DashLoader.LOG.info("Applying fonts off-thread");
            profiler.method_15405("reloading");
            this.cache.forEach((identifier, entry) -> {
                class_377 fontStorage = new class_377(fontManagerAccessor.getTextureManager(), identifier);
                FontStorageAccessor access = (FontStorageAccessor)fontStorage;
                access.callCloseFonts();
                access.callCloseGlyphAtlases();
                access.getGlyphRendererCache().clear();
                access.getGlyphCache().clear();
                access.getCharactersByWidth().clear();
                access.setBlankGlyphRenderer(class_7191.field_37899.bake(access::callGetGlyphRenderer));
                access.setWhiteRectangleGlyphRenderer(class_7191.field_37898.bake(access::callGetGlyphRenderer));
                access.getCharactersByWidth().putAll((Map)entry.getKey());
                access.getFonts().addAll((Collection)entry.getValue());
                fontStorages.put((class_2960)identifier, fontStorage);
            });
            profiler.method_15407();
            profiler.method_16066();
            ci.cancel();
        }
    }

    @Inject(method={"method_18635", "apply*"}, at={@At(value="TAIL")})
    private void applyInject(Map<class_2960, List<class_390>> map, class_3300 resourceManager, class_3695 profiler, CallbackInfo ci) {
        if (DashLoader.DL.isWrite()) {
            DashLoader.DL.getData().fonts.setMinecraftData(map);
        }
    }

    private Pair<Int2ObjectMap<IntList>, List<class_390>> computeFonts(List<class_390> fonts) {
        Int2ObjectOpenHashMap charactersByWidth = new Int2ObjectOpenHashMap();
        ArrayList fontsOut = new ArrayList();
        IntFunction<IntList> creatIntArrayListFunc = i -> new IntArrayList();
        fonts.forEach(arg_0 -> FontManagerOverride.lambda$computeFonts$6(fonts, (Int2ObjectMap)charactersByWidth, creatIntArrayListFunc, fontsOut, arg_0));
        return Pair.of((Object)charactersByWidth, fontsOut);
    }

    private static /* synthetic */ void lambda$computeFonts$6(List fonts, Int2ObjectMap charactersByWidth, IntFunction creatIntArrayListFunc, List fontsOut, class_390 currentFont) {
        currentFont.method_27442().forEach(codePoint -> {
            int fontsSize = fonts.size();
            for (int i = 0; i < fontsSize; ++i) {
                class_390 font = (class_390)fonts.get(i);
                class_379 glyph = font.method_2040(codePoint);
                if (glyph == null) continue;
                if (glyph != class_7191.field_37899) {
                    ((IntList)charactersByWidth.computeIfAbsent(class_3532.method_15386((float)glyph.method_16798(false)), creatIntArrayListFunc)).add(codePoint);
                }
                fontsOut.add(font);
                break;
            }
        });
    }

    private /* synthetic */ void lambda$prepareFonts$2(Map cache, class_2960 identifier, List fonts) {
        cache.put(identifier, this.computeFonts(Lists.reverse((List)fonts)));
    }

    @Mixin(value={class_378.class})
    private static class LeoFontSolution {
        private LeoFontSolution() {
        }

        @Inject(method={"<init>"}, at={@At(value="TAIL")})
        private void initInject(class_1060 manager, CallbackInfo ci) {
            MixinThings.FONTMANAGER = (class_378)this;
        }
    }
}

